import {
    View,
    Text,
    TextInput,
    KeyboardAvoidingView,
    ScrollView,
    Pressable,
    TouchableOpacity,
    Platform
} from "react-native";
import { useCallback } from "react";
import BackNavigation from "../../Utilities/CustomHeader/BackNavigation";
import { orderSummaryStyle } from "./OrderSummaryStyle";
import dpr from "../../Utilities/CustomStyleAttribute/dpr";
import { useState } from "react";
import { useSelector } from "react-redux";
import CustomSpinner from "../../Utilities/CustomSpinner/CustomSpinner";
import { useDispatch } from "react-redux";
import { postOrders } from "../../../redux/slices/order/postOrders";
import useAuth from "../../../hooks/useAuth";
import { useNavigation } from "@react-navigation/native";
import { RadioButton } from "react-native-radio-buttons-group";
import {
    applyCoupon,
    deleteCoupon,
    handleErrMsg,
} from "../../../redux/slices/cart/coupon/applyCoupon";
import { shippingCalculation } from "./shippingCalculation";
import { taxCalculation } from "./taxCalculation";
import { InOnScreenLoader } from "../ShoppingCart";
import DeleteIcon from "../../../assets/svgs/my wishlist/delete icon.svg";
import { deleteCouponThunk } from "../../../redux/slices/cart/coupon/deleteCoupon";
import { postSelectProduct } from "../../../redux/slices/cart/selectProduct/selectProduct";
import { loginStyles } from "../../../components/Authentication/Login/LoginStyle";
import { getMyOrders } from "../../../redux/slices/user/orderHistory/getOrderHistory";
import { getCartProduct } from "../../../redux/slices/cart/getCartProducts";
import SelectedProduct from "./SelectedProduct";
import useCustomToast from "../../../hooks/useCustomToast";
import useProcessPrice from "../../../hooks/useProcessPrice";
import usePreferences from "../../../hooks/usePreferences";
import { BASE_API_URL_STG } from "@env";
import useLangTranslation from "../../../hooks/useLangTranslation";
import { resetNewAddress } from "../../../redux/slices/user/address/postNewAddress";
import gapStyle from "../../Utilities/CommonStyles/gap.style";
import { Entypo } from '@expo/vector-icons';
import CustomSVG from "../../../src/components/CustomSVG/CustomSVG";

const OrderSummary = (props) => {
    const { trans } = useLangTranslation();
    const { priceData, selectedProducts, shippingAddress } =
        props?.route?.params;
    const navigation = useNavigation();
    const dispatch = useDispatch();
    const { access_token } = useAuth();
    const { product_general: { coupons } = {} } = usePreferences();
    const processPrice = useProcessPrice();
    const showToast = useCustomToast();
    const orderPostUrl = `${BASE_API_URL_STG}/user/orders`;
    const SELECT_SHIPPING_URL = `${BASE_API_URL_STG}/user/cart/select-shipping`;

    const { orderLoading } = useSelector((state) => state.postOrdersReducer);
    const { data, loading: selectShippingLoading } = useSelector(
        (state) => state.postSelectProductReducer
    );

    const [allProductExpanded, setAllProductExpanded] = useState(true);

    const {
        data: couponOption,
        error: couponErr,
        isLoading: couponLoading,
        successText,
    } = useSelector((state) => state.applyCouponReducer);

    const { isLoading: deleteCouponLoading } = useSelector(
        (state) => state.deleteCouponReducer
    );

    //shipping
    const shippingOptionArray = shippingCalculation(data);
    const [radioButtons, setRadioButtons] = useState(shippingOptionArray);
    const [selectedShipping, setSelectedShipping] = useState(
        shippingOptionArray[0] || { label: null, value: 0 }
    );

    async function handleRadioButton(index) {
        const data = {
            shipping_index: index,
        };
        await dispatch(
            postSelectProduct({
                access_token,
                selectURL: SELECT_SHIPPING_URL,
                method: "POST",
                data,
            })
        );
        const updateData = radioButtons.map((item) => {
            if (item.index === index) {
                setSelectedShipping(item);
                return {
                    ...item,
                    selected: true,
                };
            } else {
                return {
                    ...item,
                    selected: false,
                };
            }
        });
        setRadioButtons(updateData);
    }

    //tax
    const taxes = taxCalculation(data);
    let totalTaxesPrice = taxes.reduce(
        (acc, curr) => acc + Number(Object.values(curr)[0]),
        0
    );

    //coupon
    const [couponText, setCouponText] = useState("");

    const handleApplyCoupon = async () => {
        if (couponText === "") {
            dispatch(handleErrMsg(trans("This Field Is Required")));
        } else if (couponText) {
            dispatch(handleErrMsg(null));
            const formData = {
                discount_code: couponText,
            };
            await dispatch(applyCoupon({ access_token, formData }));

            setCouponText("");
        }
    };

    const handleDeleteCoupon = async (id) => {
        const formData = {
            index: id,
        };
        const res = await dispatch(
            deleteCouponThunk({ access_token, formData })
        );
        if (res?.payload?.status?.message === "OK") {
            dispatch(deleteCoupon(id));
        }
    };

    const grandTotalPrice =
        priceData?.totalPrice +
        Number(selectedShipping?.value) +
        totalTaxesPrice -
        couponOption.totalCouponDiscount;
    const handleProceedToPayment = async () => {
        let orderData = {
            address_id: shippingAddress.id,
            selected_tab: "old",
        };

        try {
            const res = await dispatch(
                postOrders({ access_token, orderPostUrl, orderData })
            );
            const { status, records } = res?.payload || {};
            if (status?.message === "OK") {
                dispatch(resetNewAddress());
                const CARTURL = `${BASE_API_URL_STG}/user/carts`;
                dispatch(getCartProduct({ access_token, CARTURL }));
                const URL = `${BASE_API_URL_STG}/user/orders`;
                dispatch(getMyOrders({ access_token, URL }));
                navigation.navigate("payment webview", {
                    message: "Payment",
                    itemId: records?.data?.id,
                    url: records?.data?.payment_link,
                });
            } else {
                showToast({
                    text1: status?.message
                        ? trans(status?.message)
                        : trans("Order process failed. Please try again."),
                    type: "common",
                    position: "bottom",
                    props: { variant: "error" },
                });
                navigation.navigate("my cart");
            }
        } catch (error) {
            showToast({
                text1: trans("Order process failed. Please try again."),
                type: "common",
                position: "bottom",
                props: { variant: "error" },
            });
        }
    };

    const handleExpandAllProduct = useCallback(() => {
        setAllProductExpanded(!allProductExpanded);
    }, [allProductExpanded]);

    return (
        <>
            {(couponLoading ||
                deleteCouponLoading ||
                selectShippingLoading) && <InOnScreenLoader />}
            <BackNavigation
                navigationProps={props.navigation}
                routeName={trans("order summary")}
                capitalize={false}
            />
            <KeyboardAvoidingView
                behavior={Platform.OS === "ios" ? "padding" : ""}
                style={orderSummaryStyle.cont}
            >
                <View style={orderSummaryStyle.indicatorCont}>
                    {["#33C172", "#33C172", "#A9DFC1", "#DFDFDF"].map(
                        (item, i) => (
                            <OrderIndicator key={`key${i}`} bg={item} />
                        )
                    )}
                </View>
                <ScrollView keyboardShouldPersistTaps={"always"}>
                    <View style={orderSummaryStyle.container}>
                        <View style={orderSummaryStyle.accordionContainer}>
                            <TouchableOpacity onPress={handleExpandAllProduct} style={orderSummaryStyle.accordion}>
                                <Text style={orderSummaryStyle.accordionTitle}>
                                    {trans("All Products ({{x}})", {
                                        x: selectedProducts.length,
                                    })}
                                </Text>
                                {allProductExpanded ? 
                                    <Entypo name="chevron-small-up" size={24} color="black" /> :
                                    <Entypo name="chevron-small-down" size={24} color="black" />
                                }
                            </TouchableOpacity>
                            {allProductExpanded && (
                                <View style={orderSummaryStyle.accordionDetails}>
                                    <ScrollView nestedScrollEnabled={true}>
                                        {selectedProducts.map((item, index) => (
                                            <SelectedProduct
                                                key={index}
                                                item={item}
                                                index={index}
                                                length={selectedProducts.length - 1}
                                            />
                                        ))}
                                    </ScrollView>
                                </View>
                            )}
                        </View>
                        <View style={orderSummaryStyle.productsContainer}>
                            <View
                                style={[
                                    orderSummaryStyle.priceingCont,
                                    gapStyle.mt25,
                                ]}
                            >
                                <Text style={orderSummaryStyle.price}>
                                    {trans("Subtotal")}
                                </Text>
                                <Text style={orderSummaryStyle.price}>
                                    {processPrice(priceData.totalPrice)}
                                </Text>
                            </View>
                            {shippingOptionArray.length > 0 && (
                                <View>
                                    <Text
                                        style={[
                                            orderSummaryStyle.price,
                                            orderSummaryStyle.shippingTitle,
                                            gapStyle.mb22,
                                        ]}
                                    >
                                        {trans("Select Shipping Method")}
                                    </Text>
                                    {radioButtons.length > 0 &&
                                        radioButtons.map((item) => (
                                            <View
                                                key={item.index + 1}
                                                style={
                                                    orderSummaryStyle.radioBtn
                                                }
                                            >
                                                <RadioButton
                                                    id={item.index}
                                                    label={item.label}
                                                    size={16}
                                                    selected={item.selected}
                                                    onPress={() =>
                                                        handleRadioButton(
                                                            item.index
                                                        )
                                                    }
                                                    labelStyle={[
                                                        orderSummaryStyle.shippingInfo,
                                                        orderSummaryStyle.selectShippingBg(item.selected)
                                                    ]}
                                                    borderColor={
                                                        orderSummaryStyle.shippingBorderColor(item.selected)
                                                    }
                                                />
                                                <Text
                                                    style={[
                                                        orderSummaryStyle.shippingInfo,
                                                        orderSummaryStyle.selectShippingBg(item.selected)
                                                    ]}
                                                >
                                                    {processPrice(item.value)}
                                                </Text>
                                            </View>
                                        ))}
                                </View>
                            )}
                            {Number(couponOption?.totalCouponDiscount) > 0 && (
                                <View style={orderSummaryStyle.priceingCont}>
                                    <Text style={orderSummaryStyle.price}>
                                        {trans("Coupon offer")}
                                    </Text>
                                    <Text style={orderSummaryStyle.price}>
                                        {processPrice(
                                            couponOption.totalCouponDiscount
                                        )}
                                    </Text>
                                </View>
                            )}

                            {taxes.map((item, index) => {
                                const key = Object.keys(item)[0];
                                const value = item[key];

                                return (
                                    <View
                                        key={index}
                                        style={orderSummaryStyle.priceingCont}
                                    >
                                        <Text style={orderSummaryStyle.price}>
                                            {trans(key)}
                                        </Text>
                                        <Text style={orderSummaryStyle.price}>
                                            {processPrice(value)}
                                        </Text>
                                    </View>
                                );
                            })}
                            <View
                                style={[
                                    orderSummaryStyle.priceingCont,
                                    orderSummaryStyle.grandTotal,
                                ]}
                            >
                                <Text style={orderSummaryStyle.price}>
                                    {trans("Grand Total")}
                                </Text>
                                <Text style={orderSummaryStyle.price}>
                                    {processPrice(grandTotalPrice)}
                                </Text>
                            </View>
                        </View>
                        {coupons == 1 && (
                            <View>
                                <Text style={orderSummaryStyle.cuponText}>
                                    {trans("Have a coupon? Apply Now.")}
                                </Text>
                                <View style={orderSummaryStyle.cuponInput}>
                                    <TextInput
                                        value={couponText}
                                        style={orderSummaryStyle.input}
                                        placeholder={trans("Type coupon code")}
                                        onChangeText={(text) =>
                                            setCouponText(text)
                                        }
                                    />
                                    <Pressable
                                        style={orderSummaryStyle.couponApplyBtn}
                                        onPress={handleApplyCoupon}
                                    >
                                        <Text
                                            style={orderSummaryStyle.inputText}
                                        >
                                            {trans("Apply")}
                                        </Text>
                                    </Pressable>
                                </View>
                                {couponErr !== null && (
                                    <Text
                                        style={[
                                            orderSummaryStyle.couponInfoText,
                                            orderSummaryStyle.couponErrorText,
                                        ]}
                                    >
                                        {couponErr}
                                    </Text>
                                )}
                                {successText !== null && (
                                    <Text
                                        style={[
                                            orderSummaryStyle.couponInfoText,
                                            orderSummaryStyle.couponSuccessText,
                                        ]}
                                    >
                                        {successText}
                                    </Text>
                                )}
                                {couponOption &&
                                    Object.keys(couponOption).length > 0 &&
                                    couponOption?.couponArray.length > 0 &&
                                    couponOption?.couponArray.map(
                                        (item, index) => (
                                            <View
                                                key={index}
                                                style={
                                                    orderSummaryStyle.deleteCouponCont
                                                }
                                            >
                                                <View
                                                    style={
                                                        orderSummaryStyle.deleteCouponSubCont
                                                    }
                                                >
                                                    <Pressable
                                                        onPress={() =>
                                                            handleDeleteCoupon(
                                                                item?.id
                                                            )
                                                        }
                                                    >
                                                        <CustomSVG svgIcon={DeleteIcon}
                                                            fill={"#898989"}
                                                        />
                                                    </Pressable>
                                                    <Text
                                                        style={
                                                            orderSummaryStyle.couponCode
                                                        }
                                                    >{`Coupon: ${item?.code}`}</Text>
                                                </View>
                                                <Text
                                                    style={
                                                        orderSummaryStyle.couponCode
                                                    }
                                                >
                                                    {`-${processPrice(
                                                        item?.discount_amount
                                                    )}`}
                                                </Text>
                                            </View>
                                        )
                                    )}
                            </View>
                        )}
                    </View>
                </ScrollView>
                <View style={orderSummaryStyle.checkoutBtnCont}>
                    <Pressable
                        onPress={handleProceedToPayment}
                        disabled={orderLoading}
                        style={loginStyles.loginButton}
                    >
                        {orderLoading ? (
                            <CustomSpinner
                                filePath={require("../../../assets/lottie/loader2.json")}
                                size={{
                                    width: dpr(60),
                                    height: dpr(50),
                                }}
                            />
                        ) : (
                            <Text style={loginStyles.loginButtonText}>
                                {trans("Proceed to Payment")}
                            </Text>
                        )}
                    </Pressable>
                </View>
            </KeyboardAvoidingView>
        </>
    );
};

export default OrderSummary;

export const OrderIndicator = ({ bg }) => (
    <View style={[orderSummaryStyle.orderIndicator, { borderColor: bg }]} />
);
